'use strict';

function SubmitTokensModalCtrl($scope, $rootScope, FrontCreatorToken){
    var elementId = "#modal-submit-tokens";

    $scope.title = 'Tokeny';
    $scope.users = [];
    $scope.Company = [];
    $scope.tokens = [];
    $scope.tokensValidate = 0;
    $scope.tokensRequired = 0;
    $scope.includeChefInRepresentation = false;
    $scope.tokensConfirmsMessage = '';
    $scope.typeSubmitToken = 'MAJORITY'; //ALL, REPRESENTATION, MAJORITY(większość + prezes)
    $scope.changesList = [];
    $scope.modal = false;
    $scope.methodType;

    angular.element(elementId).modal({
        backdrop: 'static'
        ,keyboard: false
        ,show: false
    });

    $scope.$on('Tokens:openSubmitTokensModal', function(event, company, params, methodType){
        $scope.Company = company;
        $scope.users = $scope.Company.user_groups.users;
        $scope.methodType = methodType;

        var userIds = [];
        for(var i = 0; i < $scope.users.length; i++){
            $scope.users[i].tokenValid = false;
            userIds.push($scope.users[i].id);
        }
        if(params['title'] != undefined) {$scope.title = params['title'];}
        if(params['modal'] != undefined) {$scope.modal = params['modal'];}
        if(params['changesList'] != undefined) {$scope.changesList = params['changesList'];}
        if(params['changes'] != undefined) {
            $scope.changes = params['changes'];
            angular.forEach($scope.changes, function(change,index){$scope.changes[index] = change.replace('<br>','');});
        }
        if(params['tokensConfirmsMessage'] != undefined) {$scope.tokensConfirmsMessage = params['tokensConfirmsMessage'];}
        if(params['typeSubmitToken'] != undefined) {$scope.typeSubmitToken = params['typeSubmitToken'];}
        if(params['tokensRequired'] != undefined) {$scope.tokensRequired = params['tokensRequired'];}

        $scope.setTokensRequired();

        FrontCreatorToken.get({users: userIds.toString()},function(data){
            $scope.tokens = data;
            angular.forEach($scope.tokens, function(token){
               token.value = '';
            });

        });
        setTimeout(function(){
            $scope.$apply();
            $("#modal-submit-tokens .nano").nanoScroller({alwaysVisible: true});
        }, 300);
        $scope.openModal();
    });

    $scope.setTokensRequired = function(){
        switch ($scope.typeSubmitToken) {
            case 'ALL' :
                $scope.tokensRequired = $scope.users.length;
                break;
            case 'REPRESENTATION' :
                var userCompanyRoles = ['M'];
                if($scope.Company.include_chef_in_representation) {userCompanyRoles.push('C');}
                $scope.users = $scope.Company.user_groups.users.filter(function(user) {
                    return (user.company_roles.filter(function(role) {return in_array(role.symbol, userCompanyRoles);}).length > 0);
                });
                $scope.tokensRequired = $scope.Company.representation_number;
                break;
            case 'MAJORITY' :
                $scope.tokensRequired = (parseInt($scope.users.length/2)+1);
                break;
        }
    }


    $scope.openModal = function(){
        if($scope.modal) {
            angular.element(elementId).modal('show');
        } else {
            angular.element(elementId).show();
        }
    }

    $scope.closeModal = function(){
        if($scope.modal) {
            angular.element(elementId).modal('hide');
        } else {
            angular.element(elementId).hide();
        }
    }

    $scope.checkValidityToken = function(user) {
        if(user.tokenValid) {
            user.tokenValid = false;
            $scope.tokensValidate--;
        }

        if($scope.tokens[user.id].token == md5($scope.tokens[user.id].value)){
            user.tokenValid = true;
            $scope.tokensValidate++;
        }
    }

    $scope.submitFormToken = function(form, stageSymbol) {
        if (form == undefined || form.$valid) {
            var state = 0;
            switch($scope.methodType)
            {
                case 'creator-notary':
                    state = 1;
                    break;
                case 'creator-estate':
                    state = 2;
                    break;
                case 'creator-bank':
                    state = 3;
                    break;
//                case '':
//                    state = 1;
//                    break;
            }
            FrontCreatorToken.save({tokens: $scope.tokens, tokensConfirmsMessage: $scope.tokensConfirmsMessage, state: state },function(data){
                $scope.tokensValidate = 0;

                $rootScope.$broadcast('Tokens:closeSubmitTokensModal',$scope.methodType);

                $scope.closeModal();
            });
        } else {
            console.log('INVALID',form.$error);
            $scope.showValidation = form.$invalid;
        }
    }

    function in_array(needle, haystack) {
        for(var i in haystack) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }

}

